/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Graveyard
**
** DESCRIPTION:	Maintains graves for deceased villagers
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef GRAVEYARD_H
#define GRAVEYARD_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "../Game/Isola.h"
#include "Villager.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

const int Graveyard_c_iGraveWidth        = 44;
const int Graveyard_c_iGraveHeight       = 55;
const int Graveyard_c_iRows              = 5;
const int Graveyard_c_iColumns           = 10;
const int Graveyard_c_iMaxGraves         = Graveyard_c_iRows * Graveyard_c_iColumns;
const int Graveyard_c_iMaxTombs          = 5;
const int Graveyard_c_iMaxEulogyLength   = 32;
const int Graveyard_c_iMaxRecordedDeaths = 500;

#define TOMB_FUDGE_X (512 * 3 - 206)
#define TOMB_FUDGE_Y (512 * 3 - 105)

const ldwPoint Graveyard_c_iTomb1TopLeft(TOMB_FUDGE_X + 246,TOMB_FUDGE_Y + 432);
const ldwPoint Graveyard_c_iTomb2TopLeft(TOMB_FUDGE_X + 411,TOMB_FUDGE_Y + 395);
const ldwPoint Graveyard_c_iTomb3TopLeft(TOMB_FUDGE_X + 365,TOMB_FUDGE_Y + 492);
const ldwPoint Graveyard_c_iTomb4TopLeft(TOMB_FUDGE_X + 548,TOMB_FUDGE_Y + 440);
const ldwPoint Graveyard_c_iTomb5TopLeft(TOMB_FUDGE_X + 527,TOMB_FUDGE_Y + 518);

const ldwPoint Graveyard_c_iTopLeft(512 * 3 + 410 - Graveyard_c_iGraveWidth * Graveyard_c_iColumns, 512 * 3 + 22);

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CGraveyard
{
public:	
	//class structures

	struct SDeathRecord
	{
		char	      m_sName[maxNameLength + 1];
		int		      m_iAge;
		ESkill	      m_eBestSkill;
		int			  m_iBestSkillLevel;
		bool          m_bWasChief;
		bool		  m_bWasElder;
		ECauseOfDeath m_eCauseOfDeath;
	};

	struct SGrave // : public SDeathRecord
	{
		int 	m_DeathRecordIndex;
		int		m_iBestSkillLevel;
		
		char	m_sEulogy[Graveyard_c_iMaxEulogyLength + 1];
	};

	struct STomb : public SGrave
	{
	};

	struct SSaveState
	{
		SGrave	     m_sGrave[Graveyard_c_iMaxGraves];
		STomb		 m_sTomb[Graveyard_c_iMaxTombs];
		SDeathRecord m_sDeathRecord[Graveyard_c_iMaxRecordedDeaths];
	};

	//setup

	CGraveyard();

	void Reset();
	const bool LoadState(const SSaveState &sSaveState);
	const bool SaveState(SSaveState &sSaveState) const;
#if _DEBUGxx
	const bool CheckState();
#endif
	//process

	void Update();
	void Draw();
	void Draw(const int graveIndex,bool scaled);

	const bool Bury(const CVillager &Villager,int carriedBy);

	//access

	const SGrave *GetGraveAtPos(const ldwPoint sWorldPos) const;
	const STomb  *GetTombAtPos(const ldwPoint sWorldPos) const;
	
	SDeathRecord *GetDeathRecord(int index);

    const int GetNumGraves()    const;
	const int GetNumTombs()     const;
	const int GetNumDead() 		const;

private:

	SGrave       m_sGrave[Graveyard_c_iMaxGraves];
	STomb		 m_sTomb[Graveyard_c_iMaxTombs];
	SDeathRecord m_sDeathRecord[Graveyard_c_iMaxRecordedDeaths];

	int m_CarriedBy[Graveyard_c_iMaxGraves + Graveyard_c_iMaxTombs];

	int m_CarriedCount;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CGraveyard		Graveyard;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/
